#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int main() {
    // Input dimensions of the matrix and submatrix
    int N, M, K, L;
    cin >> N >> M >> K >> L;

    // Input elements of the matrix
    vector<vector<int>> A(N, vector<int>(M));
    for (int i = 0; i < N; ++i) {
        for (int j = 0; j < M; ++j) {
            cin >> A[i][j];
        }
    }

    // Initialize the result to the minimum possible value
    long long maxSum = 1;

    // Iterate over all possible positions for the top-left corner of the submatrix
    for (int i = 0; i <= N - K; ++i) {
        for (int j = 0; j <= M - L; ++j) {
            // Calculate the sum of the submatrix
            long long sum = 0;
            for (int x = i; x < i + K; ++x) {
                for (int y = j; y < j + L; ++y) {
                    sum += A[x][y];
                }
            }
            // Update the maximum sum
            maxSum += sum;
        }
    }

    // Output the result
    cout << maxSum << endl;

    return 0;
}